<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Setting;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\Setting\SettingTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;

final class SettingBuilder implements InterfaceSettingSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitSettingSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            SettingTable::KEY   => '',
            SettingTable::VALUE => '',

            SettingTable::STAMP_REGISTRATION     => System::isoDateTime(),
            SettingTable::STAMP_LAST_UPDATE      => System::isoDateTime(),
        );
    }

    public function dispense(): SettingModel
    {
        return SettingModel::createFromData(
            array(
                // key

                SettingTable::KEY => $this -> key

                ?? $this -> defaultValues[SettingTable::KEY],

                // value

                SettingTable::VALUE => $this -> value

                ?? $this -> defaultValues[SettingTable::VALUE],

                // stamp registration

                SettingTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[SettingTable::STAMP_REGISTRATION],

                // stamp last update

                SettingTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[SettingTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
